/****************************************************************************/
/*                               Beebem                                     */
/*                               ------                                     */
/* This program may be distributed freely within the following restrictions:*/
/*                                                                          */
/* 1) You may not charge for this program or for any part of it.            */
/* 2) This copyright message must be distributed with all copies.           */
/* 3) This program must be distributed complete with source code.  Binary   */
/*    only distribution is not permitted.                                   */
/* 4) The author offers no warrenties, or guarentees etc. - you use it at   */
/*    your own risk.  If it messes something up or destroys your computer   */
/*    thats YOUR problem.                                                   */
/* 5) You may use small sections of code from this program in your own      */
/*    applications - but you must acknowledge its use.  If you plan to use  */
/*    large sections then please ask the author.                            */
/*                                                                          */
/* If you do not agree with any of the above then please do not use this    */
/* program.                                                                 */
/****************************************************************************/
/* Mike Wyatt and NRM's port to win32 - 7/6/97 */
/* Conveted to use DirectX - Mike Wyatt 11/1/98 */

#include <windows.h>
#include <Commdlg.h>
#include <Aygshell.h>
#include <stdio.h>
#include <initguid.h>
#include "main.h"
#include "beebwin.h"
#include "port.h"
#include "6502core.h"
#include "disc8271.h"
#include "disc1770.h"
#include "sysvia.h"
#include "uservia.h"
#include "video.h"
#include "beebsound.h"
#include "beebmem.h"
#include "resource.h"
#include "atodconv.h"
#include "beebstate.h"
#include "userkybd.h"
#include "cRegistry.h" // David Overton's registry access code.
#include "ext1770.h"
#include "uefstate.h"

HWND hWndCB = NULL;

// some LED based macros

#define LED_COLOUR_TYPE (LEDByte&4)>>2
#define LED_SHOW_KB (LEDByte&1)
#define LED_SHOW_DISC (LEDByte&2)>>1

// Registry access stuff
cRegistry SysReg;
bool RegRes;
int rbs=1;
int *binsize=&rbs;
// End of registry access stuff

FILE *CMDF2;
unsigned char CMA2;

unsigned char HideMenuEnabled;
bool MenuOn;

struct LEDType LEDs;
char DiscLedColour=0; // 0 for red, 1 for green.

// FDC Board extension DLL variables
HMODULE hFDCBoard;

typedef void (*lGetBoardProperties)(struct DriveControlBlock *);
typedef unsigned char (*lSetDriveControl)(unsigned char);
typedef unsigned char (*lGetDriveControl)(unsigned char);


lGetBoardProperties PGetBoardProperties;
lSetDriveControl PSetDriveControl;
lGetDriveControl PGetDriveControl;

EDCB ExtBoard={0,0,NULL};
bool DiscLoaded[2]={FALSE,FALSE}; // Set to TRUE when a disc image has been loaded.
char CDiscName[2][256]; // Filename of disc current in drive 0 and 1;
char CDiscType[2]; // Current disc types
bool MustEnableSound=FALSE; // Set to true if the directsound must be unmuted after menu loop exit.
char FDCDLL[256];

static const WCHAR *WindowTitle = _T("BeebEm");
static const WCHAR *AboutText = _T("BeebEm\nBBC Micro Model B/Master 128 Emulator\n")
								_T("Version 1.4, 20 December 2001\n")
								_T("Merry Christmas! - Richard Gellman :)");

/* Configuration file strings */
static const char *CFG_FILE_NAME = "BeebEm.ini";

static const WCHAR *CFG_VIEW_SECTION = _T("View");
static const WCHAR *CFG_VIEW_WIN_SIZE = _T("WinSize");
static const WCHAR *CFG_VIEW_WIN_XPOS = _T("WinXPos");
static const WCHAR *CFG_VIEW_WIN_YPOS = _T("WinYPos");
static const WCHAR *CFG_VIEW_SHOW_FPS = _T("ShowFSP");
static const WCHAR *CFG_VIEW_MONITOR = _T("Monitor");

static const WCHAR *CFG_SOUND_SECTION = _T("Sound");
static const WCHAR *CFG_SOUND_SAMPLE_RATE = _T("SampleRate");
static const WCHAR *CFG_SOUND_VOLUME = _T("Volume");
static const WCHAR *CFG_SOUND_ENABLED = _T("SoundEnabled");

static const WCHAR *CFG_OPTIONS_SECTION = _T("Options");
static const WCHAR *CFG_OPTIONS_STICKS = _T("Sticks");
static const WCHAR *CFG_OPTIONS_KEY_MAPPING = _T("KeyMapping");
static const WCHAR *CFG_OPTIONS_USER_KEY_MAP = _T("UserKeyMap");
static const WCHAR *CFG_OPTIONS_FREEZEINACTIVE = _T("FreezeWhenInactive");
static const WCHAR *CFG_OPTIONS_HIDE_CURSOR = _T("HideCursor");

static const WCHAR *CFG_SPEED_SECTION = _T("Speed");
static const WCHAR *CFG_SPEED_TIMING = _T("Timing");

static const WCHAR *CFG_MODEL_SECTION = _T("Model");

/* Prototypes */
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
int TranslateKey(int, int *, int *);

// Row,Col
static int transTable1[256][2]={
	0,0,	0,0,	0,0,	0,0,   // 0
	0,0,	0,0,	0,0,	0,0,   // 4
	5,9,	6,0,	0,0,	0,0,   // 8 [BS][TAB]..
	0,0,	4,9,	0,0,	0,0,   // 12 .RET..
	0,0,	0,1,	0,0,	-2,-2,	 // 16 .CTRL.BREAK
	4,0,	0,0,	0,0,	0,0,   // 20 CAPS...
	0,0,	0,0,	0,0,	7,0,   // 24 ...ESC
	0,0,	0,0,	0,0,	0,0,   // 28
	6,2,	-3,-3,	-3,-4,	6,9,   // 32 SPACE..[End]      2nd is Page Up 3rd is Page Down
	0,0,	1,9,	3,9,	7,9,   // 36 .[Left][Up][Right]
	2,9,	0,0,	0,0,	0,0,   // 40 [Down]...
	0,0,	0,0,	5,9,	0,0,   // 44 ..[DEL].
	2,7,	3,0,	3,1,	1,1,   // 48 0123   
	1,2,	1,3,	3,4,	2,4,   // 52 4567
	1,5,	2,6,	0,0,	0,0,   // 56 89
	0,0,	0,0,	0,0,	0,0,   // 60
	0,0,	4,1,	6,4,	5,2,   // 64.. ABC
	3,2,	2,2,	4,3,	5,3,   // 68  DEFG
	5,4,	2,5,	4,5,	4,6,   // 72  HIJK
	5,6,	6,5,	5,5,	3,6,   // 76  LMNO
	3,7,	1,0,	3,3,	5,1,   // 80  PQRS
	2,3,	3,5,	6,3,	2,1,   // 84  TUVW
	4,2,	4,4,	6,1,	0,0,   // 88  XYZ
	0,0,	6,2,	0,0,	0,0,   // 92  . SPACE ..
	0,0,	0,0,	0,0,	0,0,   // 96
	0,0,	0,0,	0,0,	0,0,   // 100
	0,0,	0,0,	0,0,	0,0,   // 104
	0,0,	0,0,	0,0,	0,0,   // 108
	7,1,	7,2,	7,3,	1,4,   // 112 F1 F2 F3 F4
	7,4,	7,5,	1,6,	7,6,   // 116 F5 F6 F7 F8
	7,7,	2,0,	2,0,	-2,-2,	 // 120 F9 F10 F11 F12
	0,0,	0,0,	0,0,	0,0,   // 124 
	0,0,	0,0,	0,0,	0,0,   // 128
	0,0,	0,0,	0,0,	0,0,   // 132
	0,0,	0,0,	0,0,	0,0,   // 136
	0,0,	0,0,	0,0,	0,0,   // 140
	0,0,	0,0,	0,0,	0,0,   // 144
	0,0,	0,0,	0,0,	0,0,   // 148
	0,0,	0,0,	0,0,	0,0,   // 152
	0,0,	0,0,	0,0,	0,0,   // 156
	0,0,	0,0,	0,0,	0,0,   // 160
	0,0,	0,0,	0,0,	0,0,   // 164
	0,0,	0,0,	0,0,	0,0,   // 168
	0,0,	0,0,	0,0,	0,0,   // 172
	0,0,	0,0,	0,0,	0,0,   // 176
	0,0,	0,0,	0,0,	0,0,   // 180
	0,0,	0,0,	5,7,	1,8,   // 184  ..;=
	6,6,	1,7,	6,7,	6,8,   // 188  ,-./
	4,8,	0,0,	0,0,	0,0,   // 192  @ ...
	0,0,	0,0,	0,0,	0,0,   // 196
	0,0,	0,0,	0,0,	0,0,   // 200
	0,0,	0,0,	0,0,	0,0,   // 204
	0,0,	0,0,	0,0,	0,0,   // 208
	0,0,	0,0,	0,0,	0,0,   // 212
	0,0,	0,0,	0,0,	3,8,   // 216 ...[
	7,8,	5,8,	2,8,	4,7,   // 220 \]#`
	0,0,	0,0,	0,0,	0,0,   // 224
	0,0,	0,0,	0,0,	0,0,   // 228
	0,0,	0,0,	0,0,	0,0,   // 232
	0,0,	0,0,	0,0,	0,0, 
	0,0,	0,0,	0,0,	0,0, 
	0,0,	0,0,	0,0,	0,0, 
	0,0,	0,0,	0,0,	0,0, 
	0,0,	0,0,	0,0,	0,0 
};
	
/* This table is better for games:
    A & S are mapped to Caps Lock and Ctrl
	F1-F9 are mapped to f0-f8 */
static int transTable2[256][2]={
	0,0,	0,0,	0,0,	0,0,   // 0
	0,0,	0,0,	0,0,	0,0,   // 4
	5,9,	6,0,	0,0,	0,0,   // 8 [BS][TAB]..
	0,0,	4,9,	0,0,	0,0,   // 12 .RET..
	0,0,	0,1,	0,0,	-2,-2,	 // 16 .CTRL.BREAK
	4,0,	0,0,	0,0,	0,0,   // 20 CAPS...
	0,0,	0,0,	0,0,	7,0,   // 24 ...ESC
	0,0,	0,0,	0,0,	0,0,   // 28
	6,2,	0,0,	0,0,	6,9,   // 32 SPACE..[End]
	0,0,	1,9,	3,9,	7,9,   // 36 .[Left][Up][Right]
	2,9,	0,0,	0,0,	-3,-3,   // 40 [Down]...
	0,0,	0,0,	5,9,	0,0,   // 44 ..[DEL].
	2,7,	3,0,	3,1,	1,1,   // 48 0123   
	1,2,	1,3,	3,4,	2,4,   // 52 4567
	1,5,	2,6,	0,0,	0,0,   // 56 89
	0,0,	0,0,	0,0,	0,0,   // 60
	0,0,	4,0,	6,4,	5,2,   // 64  . CAPS B C
	3,2,	2,2,	4,3,	5,3,   // 68  DEFG
	5,4,	2,5,	4,5,	4,6,   // 72  HIJK
	5,6,	6,5,	5,5,	3,6,   // 76  LMNO
	3,7,	1,0,	3,3,	0,1,   // 80  PQR CTRL
	2,3,	3,5,	6,3,	2,1,   // 84  TUVW
	4,2,	4,4,	6,1,	6,2,   // 88  XYZ SPACE
	6,2,	6,2,	0,0,	0,0,   // 92  SPACE SPACE ..
	0,0,	0,0,	0,0,	0,0,   // 96
	0,0,	0,0,	0,0,	0,0,   // 100
	0,0,	0,0,	0,0,	0,0,   // 104
	0,0,	0,0,	0,0,	0,0,   // 108
	2,0,	7,1,	7,2,	7,3,   // 112 F1 F2 F3 F4      - f0 f1 f2 f3
	1,4,	7,4,	7,5,	1,6,   // 116 F5 F6 F7 F8      - f4 f5 f6 f7
	7,6,	2,0,	7,7,	-2,-2,	 // 120 F9 F10 F11 F12 - f8 .  f9 BREAK
	0,0,	0,0,	0,0,	0,0,   // 124 
	0,0,	0,0,	0,0,	0,0,   // 128
	0,0,	0,0,	0,0,	0,0,   // 132
	0,0,	0,0,	0,0,	0,0,   // 136
	0,0,	0,0,	0,0,	0,0,   // 140
	0,0,	0,0,	0,0,	0,0,   // 144
	0,0,	0,0,	0,0,	0,0,   // 148
	0,0,	0,0,	0,0,	0,0,   // 152
	0,0,	0,0,	0,0,	0,0,   // 156
	0,0,	0,0,	0,0,	0,0,   // 160
	0,0,	0,0,	0,0,	0,0,   // 164
	0,0,	0,0,	0,0,	0,0,   // 168
	0,0,	0,0,	0,0,	0,0,   // 172
	0,0,	0,0,	0,0,	0,0,   // 176
	0,0,	0,0,	0,0,	0,0,   // 180
	0,0,	0,0,	5,7,	1,8,   // 184  ..;=
	6,6,	1,7,	6,7,	6,8,   // 188  ,-./
	4,8,	0,0,	0,0,	0,0,   // 192  @ ...
	0,0,	0,0,	0,0,	0,0,   // 196
	0,0,	0,0,	0,0,	0,0,   // 200
	0,0,	0,0,	0,0,	0,0,   // 204
	0,0,	0,0,	0,0,	0,0,   // 208
	0,0,	0,0,	0,0,	0,0,   // 212
	0,0,	0,0,	0,0,	3,8,   // 216 ...[
	7,8,	5,8,	2,8,	4,7,   // 220 \]#`
	0,0,	0,0,	0,0,	0,0,   // 224
	0,0,	0,0,	0,0,	0,0,   // 228
	0,0,	0,0,	0,0,	0,0,   // 232
	0,0,	0,0,	0,0,	0,0, 
	0,0,	0,0,	0,0,	0,0, 
	0,0,	0,0,	0,0,	0,0, 
	0,0,	0,0,	0,0,	0,0, 
	0,0,	0,0,	0,0,	0,0 
};

/* Currently selected translation table */
static int (*transTable)[2] = transTable1;
long WindowPos[4];

BeebWin::BeebWin()
{   
}

/****************************************************************************/
void BeebWin::Initialise()
{   
	char CfgName[256];
	int row, col;
	int LEDByte=0;
	LARGE_INTEGER Dummy_Var;
	HANDLE m_hThread;

	m_MenuIdWinSize = IDM_320X256;
	TranslateWindowSize();

	m_ShowSpeedAndFPS = 1;

	palette_type = PaletteType(0);

	m_MenuIdTiming = IDM_REALTIME;
	TranslateTiming();

	m_MenuIdSampleRate = IDM_22050KHZ;
	TranslateSampleRate();

	m_MenuIdVolume = IDM_MEDIUMVOLUME;
	TranslateVolume();

	m_MenuIdSticks = 0;

	m_FreezeWhenInactive = 1;

	m_HideCursor = 0;

	m_MenuIdKeyMapping = IDM_KEYBOARDMAPPING1;
	TranslateKeyMapping();

/*
	for (int key=0; key<256; ++key)
	{
		sprintf(CfgName, "%s%d", CFG_OPTIONS_USER_KEY_MAP, key);
		GetPrivateProfileString(CFG_OPTIONS_SECTION, CfgName, "-1 -1",
				CfgValue, sizeof(CfgValue), CFG_FILE_NAME);
		sscanf(CfgValue, "%d %d", &row, &col);
		if (row != -1 && col != -1)
		{
			UserKeymap[key][0] = row;
			UserKeymap[key][1] = col;
		}
	}
*/

	HideMenuEnabled=0;
	LEDByte=0;
	OpCodes=2;
	BHardware=0;
	THalfMode=0;
	PartSamples=1;
	SoundDefault=1;
	SBSize=0;

	DiscLedColour=LED_COLOUR_TYPE;
	LEDs.ShowDisc=LED_SHOW_DISC;
	LEDs.ShowKB=LED_SHOW_KB;

	IgnoreIllegalInstructions = 1;

	m_WriteProtectDisc[0] = !IsDiscWritable(0);
	m_WriteProtectDisc[1] = !IsDiscWritable(1);

	m_hBitmap = m_hOldObj = m_hDCBitmap = NULL;
	m_ScreenRefreshCount = 0;
	m_RelativeSpeed = 1;
	m_FramesPerSecond = 50;
	wcscpy(m_szTitle, WindowTitle);

	for(int i=0;i<12;i++)
		cols[i] = i;

	InitClass();
	CreateBeebWindow(); 
	CreateBitmap();

	HMENU hm = NULL;

	hm = (HMENU)SendMessage((hWndCB), SHCMBM_GETSUBMENU, (WPARAM)0, 
                             (LPARAM)IDM_MAIN_MENUITEM2);

	InitMenu();

	m_hDC = GetDC(m_hWnd);

//	if (SoundEnabled)
//		SoundInit();

	/* Joysticks can only be initialised after the window is created (needs hwnd) */
	if (m_MenuIdSticks == IDM_JOYSTICK)
		InitJoystick();

	WCHAR lpFileName[MAX_PATH];
	GetModuleFileName(NULL, lpFileName, MAX_PATH);
	WideCharToMultiByte(CP_ACP, NULL, lpFileName, -1, m_AppPath, 256, NULL, NULL);

	m_frozen = FALSE;
	strcpy(RomPath, m_AppPath);
	strcpy(RomPath, "");

	strcpy(m_AppPath, "\\");


	UpdateModelType();
	UpdateSFXMenu();
	UpdateLEDMenu(m_hMenu);
	MenuOn=TRUE;
	strcpy(FDCDLL,"None");

	NativeFDC=TRUE;
	if (NativeFDC) {
		CheckMenuItem(m_hMenu,ID_8271,MF_CHECKED);
		CheckMenuItem(m_hMenu,ID_FDC_DLL,MF_UNCHECKED);
	} else {
		CheckMenuItem(m_hMenu,ID_8271,MF_UNCHECKED);
		CheckMenuItem(m_hMenu,ID_FDC_DLL,MF_CHECKED);
	}
	DisplayCycles=7000000;
	if ((NativeFDC)) DisplayCycles=0;
	BOOL pfr;
	pfr=QueryPerformanceFrequency(&Dummy_Var);
	CheckMenuItem(m_hMenu,ID_PSAMPLES,(PartSamples)?MF_CHECKED:MF_UNCHECKED);
	UpdateOptiMenu();

}

void BeebWin::SetDriveControl(unsigned char value) {
	// This takes a value from the mem/io decoder, as written by the cpu, runs it through the 
	// DLL's translator, then sends it on to the 1770 FDC in master 128 form.
	WriteFDCControlReg(PSetDriveControl(value));
}

unsigned char BeebWin::GetDriveControl(void) {
	// Same as above, but in reverse, i.e. reading
	unsigned char temp,temp2;
	temp=ReadFDCControlReg();
	temp2=PGetDriveControl(temp);
	return(temp2);
}
/****************************************************************************/
BeebWin::~BeebWin()
{   
	if (SoundEnabled)
		SoundReset();

	ReleaseDC(m_hWnd, m_hDC);

	if (m_hOldObj != NULL)
		SelectObject(m_hDCBitmap, m_hOldObj);
	if (m_hBitmap != NULL)
		DeleteObject(m_hBitmap);
	if (m_hDCBitmap != NULL)
		DeleteDC(m_hDCBitmap);
	// Write back position of window for reloading
}

void SaveWindowPos(void) {
}
/****************************************************************************/
void BeebWin::ResetBeebSystem(unsigned char NewModelType,unsigned char TubeStatus,unsigned char LoadRoms) 
{
	SwitchOnCycles=0; // Reset delay
	SoundReset();
	if (SoundDefault) SoundInit();
	SoundChipReset();
	SwitchOnSound();
	memset(WholeRam,0,0x8000);
	PagedRomReg=0xf;
	BeebMemInit(LoadRoms);
	Init6502core();
	SysVIAReset();
	UserVIAReset();
	VideoInit();
	Disc8271_reset();
	Reset1770();
	AtoDReset();
	SetRomMenu();
	FreeDiscImage(0);
	// Keep the disc images loaded
	FreeDiscImage(1);
	Close1770Disc(0);
	Close1770Disc(1);
	if ((NativeFDC)) {
		// 8271 disc
		if ((DiscLoaded[0]) && (CDiscType[0]==0)) LoadSimpleDiscImage(CDiscName[0],0,0,80);
		if ((DiscLoaded[0]) && (CDiscType[0]==1)) LoadSimpleDSDiscImage(CDiscName[0],0,80);
		if ((DiscLoaded[1]) && (CDiscType[1]==0)) LoadSimpleDiscImage(CDiscName[1],0,0,80);
		if ((DiscLoaded[1]) && (CDiscType[1]==1)) LoadSimpleDSDiscImage(CDiscName[1],0,80);
	}
	if (((!NativeFDC))) {
		// 1770 Disc
		if (DiscLoaded[0]) Load1770DiscImage(CDiscName[0],0,CDiscType[0],m_hMenu);
		if (DiscLoaded[1]) Load1770DiscImage(CDiscName[1],1,CDiscType[1],m_hMenu);
	}
}
/****************************************************************************/
void BeebWin::CreateBitmap()
{
	if (m_hBitmap != NULL)
		DeleteObject(m_hBitmap);
	if (m_hDCBitmap != NULL)
		DeleteDC(m_hDCBitmap);

	m_hDCBitmap = CreateCompatibleDC(NULL);

	m_bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	m_bmi.bmiHeader.biWidth = 800;
	m_bmi.bmiHeader.biHeight = -512;
	m_bmi.bmiHeader.biPlanes = 1;
	m_bmi.bmiHeader.biBitCount = 8;
	m_bmi.bmiHeader.biCompression = BI_RGB;
	m_bmi.bmiHeader.biSizeImage = 800*512;
	m_bmi.bmiHeader.biClrUsed = 12;
	m_bmi.bmiHeader.biClrImportant = 12;

#ifdef USE_PALETTE
	__int16 *pInts = (__int16 *)&m_bmi.bmiColors[0];
    
	for(int i=0; i<12; i++)
		pInts[i] = i;
    
	m_hBitmap = CreateDIBSection(m_hDCBitmap, (BITMAPINFO *)&m_bmi, DIB_PAL_COLORS,
							(void**)&m_screen, NULL,0);
#else
	for (int i = 0; i < 9; ++i)
	{
    float r,g,b;
    r = (float) (i & 1);
    g = (float) ((i & 2) >> 1);
    b = (float) ((i & 4) >> 2);

    if (palette_type != RGB) {
      r = g = b = (float) (0.299 * r + 0.587 * g + 0.114 * b);
      switch (palette_type) {
      case AMBER:
        r *= (float) 1.0;
        g *= (float) 0.8;
        b *= (float) 0.1;
        break;
      case GREEN:
        r *= (float) 0.2;
        g *= (float) 0.9;
        b *= (float) 0.1;
        break;
      }
    }

		m_bmi.bmiColors[i].rgbRed   = (unsigned char) (r * 255);
		m_bmi.bmiColors[i].rgbGreen = (unsigned char) (g * 255);
		m_bmi.bmiColors[i].rgbBlue  = (unsigned char) (b * 255);
		m_bmi.bmiColors[i].rgbReserved = 0;
	}

	// Red Leds - left is dark, right is lit.
	m_bmi.bmiColors[8].rgbRed=80;		m_bmi.bmiColors[9].rgbRed=255;
	m_bmi.bmiColors[8].rgbGreen=0;		m_bmi.bmiColors[9].rgbGreen=0;
	m_bmi.bmiColors[8].rgbBlue=0;		m_bmi.bmiColors[9].rgbBlue=0;
	m_bmi.bmiColors[8].rgbReserved=0;	m_bmi.bmiColors[9].rgbReserved=0;
	// Green Leds - left is dark, right is lit.
	m_bmi.bmiColors[10].rgbRed=0;		m_bmi.bmiColors[11].rgbRed=0;
	m_bmi.bmiColors[10].rgbGreen=80;		m_bmi.bmiColors[11].rgbGreen=255;
	m_bmi.bmiColors[10].rgbBlue=0;		m_bmi.bmiColors[11].rgbBlue=0;
	m_bmi.bmiColors[10].rgbReserved=0;	m_bmi.bmiColors[11].rgbReserved=0;

	m_hBitmap = CreateDIBSection(m_hDCBitmap, (BITMAPINFO *)&m_bmi, DIB_RGB_COLORS,
							(void**)&m_screen, NULL,0);
#endif

	m_hOldObj = SelectObject(m_hDCBitmap, m_hBitmap);
	if(m_hOldObj == NULL)
		MessageBox(m_hWnd,_T("Cannot select the screen bitmap\n")
					_T("Try running in a 256 colour mode"),WindowTitle,MB_OK|MB_ICONERROR);
}

/****************************************************************************/
BOOL BeebWin::InitClass(void)
{
	WNDCLASS  wc;

	// Fill in window class structure with parameters that describe the
	// main window.

	wc.style		 = 0;						// Class style(s).
	wc.lpfnWndProc	 = (WNDPROC)WndProc;	   // Window Procedure
	wc.cbClsExtra	 = 0;					   // No per-class extra data.
	wc.cbWndExtra	 = 0;					   // No per-window extra data.
	wc.hInstance	 = hInst;				   // Owner of this class
	wc.hIcon		 = NULL;
	wc.hCursor		 = NULL;
	wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);// Default color
	wc.lpszMenuName  = NULL;								// Menu from .RC
	wc.lpszClassName = _T("BEEBWIN"); //szAppName;				// Name to register as

	// Register the window class and return success/failure code.
	return (RegisterClass(&wc));
}

/****************************************************************************/
void BeebWin::CreateBeebWindow(void)
{
	DWORD style;
	int x,y;
	char CfgValue[256];

	x = 0;
	y = 26;
	m_XWinPos = 0;
	m_YWinPos = 0;

	style = WS_POPUP;

	m_hWnd = CreateWindow(
				_T("BEEBWIN"),				// See RegisterClass() call.
				m_szTitle, 		// Text for window title bar.
				style,
				x, y,
				m_XWinSize + GetSystemMetrics(SM_CXFIXEDFRAME) * 2,
				m_YWinSize + GetSystemMetrics(SM_CYFIXEDFRAME) * 2
					+ 1,
				NULL,					// Overlapped windows have no parent.
				NULL,				 // Use the window class menu.
				hInst,			 // This instance owns this window.
				NULL				 // We don't use any data in our WM_CREATE
		); 

	ShowWindow(m_hWnd, SW_SHOW); // Show the window
	UpdateWindow(m_hWnd);		  // Sends WM_PAINT message
}

void BeebWin::ShowMenu(bool on) {
 if (on!=MenuOn) {
 }
  MenuOn=on;
}

/****************************************************************************/
void BeebWin::InitMenu(void)
{
	char menu_string[256];
	HMENU hMenu = m_hMenu;

	CheckMenuItem(hMenu, IDM_SPEEDANDFPS, m_ShowSpeedAndFPS ? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, m_MenuIdWinSize, MF_CHECKED);
	CheckMenuItem(hMenu, IDM_SOUNDONOFF, SoundEnabled ? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, m_MenuIdSampleRate, MF_CHECKED);
	CheckMenuItem(hMenu, m_MenuIdVolume, MF_CHECKED);
	CheckMenuItem(hMenu, IDM_ALLOWALLROMWRITES, WritableRoms ? MF_CHECKED : MF_UNCHECKED); 
	CheckMenuItem(hMenu, m_MenuIdTiming, MF_CHECKED);
	if (m_MenuIdSticks != 0)
		CheckMenuItem(hMenu, m_MenuIdSticks, MF_CHECKED);
	CheckMenuItem(hMenu, IDM_FREEZEINACTIVE, m_FreezeWhenInactive ? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, IDM_HIDECURSOR, m_HideCursor ? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, IDM_IGNOREILLEGALOPS,
					IgnoreIllegalInstructions ? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, m_MenuIdKeyMapping, MF_CHECKED);
	CheckMenuItem(hMenu, IDM_WPDISC0, m_WriteProtectDisc[0] ? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, IDM_WPDISC1, m_WriteProtectDisc[1] ? MF_CHECKED : MF_UNCHECKED);

  CheckMenuItem(hMenu, ID_HIDEMENU, HideMenuEnabled ? MF_CHECKED:MF_UNCHECKED);

  UpdateMonitorMenu();

	/* Initialise the ROM Menu. */
	SetRomMenu();
}

void BeebWin::UpdateMonitorMenu() {
	HMENU hMenu = m_hMenu;
  CheckMenuItem(hMenu, ID_MONITOR_RGB, (palette_type == RGB) ? MF_CHECKED : MF_UNCHECKED);
  CheckMenuItem(hMenu, ID_MONITOR_BW , (palette_type == BW) ? MF_CHECKED : MF_UNCHECKED);
  CheckMenuItem(hMenu, ID_MONITOR_GREEN , (palette_type == GREEN) ? MF_CHECKED : MF_UNCHECKED);
  CheckMenuItem(hMenu, ID_MONITOR_AMBER , (palette_type == AMBER) ? MF_CHECKED : MF_UNCHECKED);
}

void BeebWin::UpdateModelType() {
}

void BeebWin::UpdateSFXMenu() {
	HMENU hMenu = m_hMenu;
}

/****************************************************************************/
void BeebWin::SetRomMenu(void)
{
	HMENU hMenu = m_hMenu;

	// Set the ROM Titles in the ROM/RAM menu.
	CHAR Title[19];
	
	int	 i;

	for( i=0; i<16; i++ )
	{
		Title[0] = '&';
		_itoa( i, &Title[1], 16 );
		Title[2] = ' ';
		
		// Get the Rom Title.
		ReadRomTitle( i, &Title[3], sizeof( Title )-4);
	
		if ( Title[3]== '\0' )
			strcpy( &Title[3], "Empty" );

/*
		ModifyMenu( hMenu,	// handle of menu 
					IDM_ALLOWWRITES_ROM0 + i,
					MF_BYCOMMAND,	// menu item to modify
				//	MF_STRING,	// menu item flags 
					IDM_ALLOWWRITES_ROM0 + i,	// menu item identifier or pop-up menu handle
					Title		// menu item content 
					);
*/

  	/* LRW Now uncheck the Roms which are NOT writable, that have already been loaded. */
  	CheckMenuItem(hMenu, IDM_ALLOWWRITES_ROM0 + i, RomWritable[i] ? MF_CHECKED : MF_UNCHECKED );
  }
}

/****************************************************************************/
void BeebWin::GetRomMenu(void)
{
	HMENU hMenu = m_hMenu;

//  for (int i=0; i<16; ++i)
	/* LRW Now uncheck the Roms as NOT writable, that have already been loaded. */
//	  RomWritable[i] = ( GetMenuState(hMenu, IDM_ALLOWWRITES_ROM0 + i, MF_BYCOMMAND ) & MF_CHECKED );
}

/****************************************************************************/
void BeebWin::GreyRomMenu(BOOL SetToGrey)
{
	HMENU hMenu = m_hMenu;

  for (int i=1; i<16; ++i)
  	EnableMenuItem(hMenu, IDM_ALLOWWRITES_ROM0 + i, SetToGrey ? MF_GRAYED : MF_ENABLED );
}

/****************************************************************************/
void BeebWin::InitJoystick(void)
{
}

/****************************************************************************/
void BeebWin::ScaleJoystick(unsigned int x, unsigned int y)
{
	/* Scale and reverse the readings */
	JoystickX = (int)((double)(65536 - x) * 65536.0 /
						(double)(65536 - 0));
	JoystickY = (int)((double)(65536 - y) * 65536.0 /
						(double)(65536 - 0));
}

/****************************************************************************/
void BeebWin::ResetJoystick(void)
{
//	joyReleaseCapture(JOYSTICKID1);
	AtoDReset();
}

/****************************************************************************/
void BeebWin::SetMousestickButton(int button)
{
	if (m_MenuIdSticks == IDM_MOUSESTICK)
		JoystickButton = button;
}

/****************************************************************************/
void BeebWin::ScaleMousestick(unsigned int x, unsigned int y)
{
	if (m_MenuIdSticks == IDM_MOUSESTICK)
	{
		JoystickX = (m_XWinSize - x - 1) * 65536 / m_XWinSize;
		JoystickY = (m_YWinSize - y - 1) * 65536 / m_YWinSize;
	}

	if (m_HideCursor)
		SetCursor(NULL);
}

/****************************************************************************/
LRESULT CALLBACK WndProc(
				HWND hWnd,		   // window handle
				UINT message,	   // type of message
				WPARAM uParam,	   // additional information
				LPARAM lParam)	   // additional information
{
	int wmId, wmEvent;
	HDC hdc;
	int row, col;
	FILE *f;

/*
	if (message != WM_PAINT)
	{
		f = fopen("\\cmd.txt", "at");
		if (f) {
			SYSTEMTIME SystemTime;

			GetSystemTime(&SystemTime);
			fprintf(f, "%02d:%03d %d, %d, %d\n", 
				SystemTime.wSecond, 
				SystemTime.wMilliseconds,
				message, uParam, lParam); 
			fclose(f);
		}
	}
*/
	
	switch (message)
	{
		case WM_COMMAND:  // message: command from application menu
			wmId	= LOWORD(uParam);
			wmEvent = HIWORD(uParam);
			if (mainWin)
				mainWin->HandleCommand(wmId);
			break;						  

      case WM_CREATE:
            //Create the menubar.
            SHMENUBARINFO mbi;

            memset (&mbi, 0, sizeof (SHMENUBARINFO));
            mbi.cbSize     = sizeof (SHMENUBARINFO);
            mbi.hwndParent = hWnd;
            mbi.nToolBarId = IDM_MAIN_MENU;
            mbi.hInstRes   = hInst;
            mbi.nBmpId     = 0;
            mbi.cBmpImages = 0;  

            if (!SHCreateMenuBar(&mbi))
              MessageBox(hWnd, L"SHCreateMenuBar Failed", L"Error", MB_OK);
            else
			{
              hWndCB = mbi.hwndMB;
			  mainWin->m_hMenu = (HMENU) SendMessage(hWndCB,SHCMBM_GETMENU,0,0);
			}
			break;
			
		case WM_PALETTECHANGED:
			if(!mainWin)
				break;
			if ((HWND)uParam == hWnd)
				break;

			// fall through to WM_QUERYNEWPALETTE
		case WM_QUERYNEWPALETTE:
			if(!mainWin)
				break;

			hdc = GetDC(hWnd);
			mainWin->RealizePalette(hdc);
			ReleaseDC(hWnd,hdc);    
			return TRUE;							    
			break;

		case WM_PAINT:
			if(mainWin != NULL) {
				PAINTSTRUCT ps;
				HDC 		hDC;

				hDC = BeginPaint(hWnd, &ps);
				mainWin->RealizePalette(hDC);
				mainWin->updateLines(hDC, 0, (TeletextEnabled)?500:256);
				EndPaint(hWnd, &ps);
			}
			break;

		case WM_KEYDOWN:
			if(TranslateKey(uParam, &row, &col)>=0)
				BeebKeyDown(row, col);
			break;

		case WM_KEYUP:
			if(TranslateKey(uParam,&row, &col)>=0)
				BeebKeyUp(row, col);
			else if(row==-2)
			{ // Must do a reset!
				Init6502core();
				Disc8271_reset();
				Reset1770();
				//SoundChipReset();
			}
			else if(row==-3)
			{
				if (col==-3) SoundTuning+=0.1; // Page Up
				if (col==-4) SoundTuning-=0.1; // Page Down
			}
			break;					  

		case WM_SETFOCUS:
			if (mainWin)
				mainWin->Focus(TRUE);
			break;

		case WM_KILLFOCUS:

			BeebReleaseAllKeys();
			if (mainWin)
				mainWin->Focus(FALSE);
			break;					  

//		case MM_JOY1MOVE:
//			if (mainWin)
//				mainWin->ScaleJoystick(LOWORD(lParam), HIWORD(lParam));
//			break;
//
//		case MM_JOY1BUTTONDOWN:
//		case MM_JOY1BUTTONUP:
//			JoystickButton = ((UINT)uParam & (JOY_BUTTON1 | JOY_BUTTON2)) ? 1 : 0;
//			break; 

		case WM_MOUSEMOVE:
			if (mainWin)
			{
				mainWin->ScaleMousestick(LOWORD(lParam), HIWORD(lParam));
// Experiment: show menu in full screen when cursor moved to top of window
					if (HideMenuEnabled) {
						if (HIWORD(lParam) <= 2)
							mainWin->ShowMenu(true);
						else
							mainWin->ShowMenu(false);
					}
			}
			break;

		case WM_LBUTTONDOWN:
			if (mainWin)
				mainWin->SetMousestickButton(((UINT)uParam & MK_LBUTTON) ? TRUE : FALSE);
			break;
		case WM_LBUTTONUP:
			if (mainWin)
				mainWin->SetMousestickButton(((UINT)uParam & MK_LBUTTON) ? TRUE : FALSE);
			break;

		case WM_MBUTTONDOWN:
			break;
		case WM_MBUTTONUP:
			break;
		case WM_RBUTTONDOWN:
			break;

		case WM_RBUTTONUP:
// Experiment: tried popping up the main menu on right click in full screen,
// however, it doesn't display corrently.
//      if (mainWin && mainWin->IsFullScreen() && (!AMXMouseEnabled || (uParam & MK_SHIFT)))
//        mainWin->TrackPopupMenu(LOWORD(lParam), HIWORD(lParam));
			break;

		case WM_DESTROY:  // message: window being destroyed
			PostQuitMessage(0);
			break;

		case WM_ENTERMENULOOP: // entering menu, must mute directsound
			SetSound(MUTED);
			break;

		case WM_EXITMENULOOP:
			SetSound(UNMUTED);
			break;

		default:		  // Passes it on if unproccessed
			return (DefWindowProc(hWnd, message, uParam, lParam));
		}
	return (0);
}

/****************************************************************************/
int TranslateKey(int vkey, int *row, int *col)
{
	row[0] = transTable[vkey][0];
	col[0] = transTable[vkey][1];   

	return(row[0]);
}

/****************************************************************************/
int BeebWin::StartOfFrame(void)
{
	int FrameNum = 1;

	if (UpdateTiming()) {
		FrameNum = 0;
		// Blank screen on frame 0
		memset(m_screen,0,800*((TeletextEnabled)?500:256));
	}

	return FrameNum;
}

void BeebWin::doLED(int sx,bool on) {
	int tsy; char colbase;
	colbase=(DiscLedColour*2)+8; // colour will be 0 for red, 1 for green.
	if (sx<100) colbase=8; // Red leds for keyboard always
	if (TeletextEnabled) tsy=496; else tsy=254;
	doUHorizLine(mainWin->cols[((on)?1:0)+colbase],tsy,sx,8);
	doUHorizLine(mainWin->cols[((on)?1:0)+colbase],tsy,sx,8);
};

/****************************************************************************/
void BeebWin::updateLines(HDC hDC, int starty, int nlines)
{

	int TTLines=0;

//	int TextStart=236; 
//	if (TeletextEnabled) TextStart=(480/TeletextStyle)-((TeletextStyle==2)?12:0);

	++m_ScreenRefreshCount;
	TTLines=512/TeletextStyle;

	int win_starty = starty * m_YWinSize / 256;
	int win_nlines = 256 * m_YWinSize / 256;
//	StretchBlt(hDC, 0, win_starty, m_XWinSize, win_nlines,
//	m_hDCBitmap, 0, starty, (TeletextEnabled)?552:ActualScreenWidth, (TeletextEnabled==1)?TTLines:256, SRCCOPY);

	StretchBlt(hDC, 0, win_starty, m_XWinSize, win_nlines,
	m_hDCBitmap, 0, starty, (TeletextEnabled)?480:ActualScreenWidth, (TeletextEnabled==1)?TTLines:256, SRCCOPY);

}

/****************************************************************************/
BOOL BeebWin::UpdateTiming(void)
{
	static unsigned long LastTotalCycles = 0;
	static unsigned long LastTickCount = 0;
	static unsigned long LastTimingDispCount = 0;
	static unsigned long LastFPSCount = 0;
	static double FrameUpdateTotal = 0.0;
	static double FrameUpdateIncrement = 1.0;
	double AdjustedRelativeSpeed;
	unsigned long Cycles;
	unsigned long Ticks, TickCount;
	BOOL UpdateScreen = TRUE;

	if (LastTickCount == 0)
	{
		LastTimingDispCount = LastTickCount = LastFPSCount = GetTickCount();
		LastTotalCycles = TotalCycles;
	}
	else
	{
		/* Only update timings every second */
		TickCount = GetTickCount();
		Ticks = TickCount - LastTickCount;

		/* Don't do anything if this is the first call after
			a long pause due to menu commands. */
		if (Ticks >= 1000)
		{
			LastTotalCycles = TotalCycles;
			LastTickCount = TickCount;
			LastFPSCount = TickCount;
			LastTimingDispCount = TickCount;
		}
		else
		{
			if (Ticks >= 500)
			{
				if ((unsigned long)TotalCycles < LastTotalCycles)
				{
					/* Wrap around in cycle count */
					Cycles = TotalCycles + (CycleCountWrap - LastTotalCycles);
				}
				else
				{	
					Cycles = TotalCycles - LastTotalCycles;
				}

				/* Ticks are in ms, Cycles are in 0.5 us (beeb runs at 2MHz) */
				m_RelativeSpeed = (Cycles / 2000.0) / Ticks;
				m_FramesPerSecond += (m_ScreenRefreshCount * 1000.0) / Ticks;
				m_FramesPerSecond /= 2.0;
				m_ScreenRefreshCount = 0;

				if (m_FPSTarget == 0)
				{
					AdjustedRelativeSpeed = m_RelativeSpeed + 1.0 - m_RealTimeTarget;
					FrameUpdateIncrement *= AdjustedRelativeSpeed * AdjustedRelativeSpeed;
					if (FrameUpdateIncrement < 0.05)
						FrameUpdateIncrement = 0.05;
				}

				/* Only update timing display every second */
				if (TickCount > LastTimingDispCount + 1000)
				{
					LastTimingDispCount = TickCount;
					DisplayTiming();
				}

				LastTotalCycles = TotalCycles;
				LastTickCount = TickCount;
			}

			if (m_FPSTarget == 0)
			{
				/* One of the real time speeds required */
				if (FrameUpdateIncrement > 1.0)
				{
					/* Sleep for a bit */
					Sleep((long)(FrameUpdateIncrement - 1.0));
					UpdateScreen = TRUE;
				}
				else
				{
					FrameUpdateTotal += FrameUpdateIncrement;
					if (FrameUpdateTotal >= 1.0)
					{
						UpdateScreen = TRUE;
						FrameUpdateTotal -= 1.0;
					}
					else
					{
						UpdateScreen = FALSE;
					}
				}
			}
			else
			{
				/* Fast as possible with a certain frame rate */
				if (TickCount >= LastFPSCount + (1000 / m_FPSTarget))
				{
					UpdateScreen = TRUE;
					LastFPSCount += 1000 / m_FPSTarget;
				}
				else
				{
					UpdateScreen = FALSE;
				}
			}
	
		}
	}

	return UpdateScreen;
}

/****************************************************************************/
void BeebWin::DisplayTiming(void)
{
	if (m_ShowSpeedAndFPS)
	{
//		wsprintf(m_szTitle, _T("%s  Speed: %2.2f  fps: %2.2f"),
//				WindowTitle, m_RelativeSpeed, m_FramesPerSecond);
		wsprintf(m_szTitle, _T("Speed: %2.2f  fps: %2.2f"),
				m_RelativeSpeed, m_FramesPerSecond);
		SetWindowText(m_hWnd, m_szTitle);
	}
}

/****************************************************************************/
void BeebWin::TranslateWindowSize(void)
{
  switch (m_MenuIdWinSize)
	  {
	  case IDM_320X256:
		  m_XWinSize = 240;
		  m_YWinSize = 256;
		  break;
	  }
}

/****************************************************************************/
void BeebWin::TranslateSampleRate(void)
{
	switch (m_MenuIdSampleRate)
	{
	case IDM_44100KHZ:
		SoundSampleRate = 44100;
		break;

	default:
	case IDM_22050KHZ:
		SoundSampleRate = 22050;
		break;

	case IDM_11025KHZ:
		SoundSampleRate = 11025;
		break;
	}
}

/****************************************************************************/
void BeebWin::TranslateVolume(void)
{
	switch (m_MenuIdVolume)
	{
	case IDM_FULLVOLUME:
		SoundVolume = 1;
		break;

	case IDM_HIGHVOLUME:
		SoundVolume = 2;
		break;

	default:
	case IDM_MEDIUMVOLUME:
		SoundVolume = 3;
		break;

	case IDM_LOWVOLUME:
		SoundVolume = 4;
		break;
	}
}

/****************************************************************************/
void BeebWin::TranslateTiming(void)
{
	m_FPSTarget = 0;
	m_RealTimeTarget = 1.0;

	switch (m_MenuIdTiming)
	{
	default:
	case IDM_REALTIME:
		m_RealTimeTarget = 1.0;
		break;

	case IDM_3QSPEED:
		m_RealTimeTarget = 0.75;
		break;

	case IDM_HALFSPEED:
		m_RealTimeTarget = 0.5;
		break;

	case IDM_50FPS:
		m_FPSTarget = 50;
		break;

	case IDM_25FPS:
		m_FPSTarget = 25;
		break;

	case IDM_10FPS:
		m_FPSTarget = 10;
		break;

	case IDM_5FPS:
		m_FPSTarget = 5;
		break;

	case IDM_1FPS:
		m_FPSTarget = 1;
		break;
	}
}

/****************************************************************************/
void BeebWin::TranslateKeyMapping(void)
{
	switch (m_MenuIdKeyMapping )
	{
	default:
	case IDM_KEYBOARDMAPPING1:
		transTable = transTable1;
		break;

	case IDM_KEYBOARDMAPPING2:
		transTable = transTable2;
		break;

	case IDM_USERKYBDMAPPING:
		transTable = UserKeymap;
		break;
	}
}

void BeebWin::SetImageName(char *DiscName,char Drive,char DType) {
	strcpy(CDiscName[Drive],DiscName);
	CDiscType[Drive]=DType;
	DiscLoaded[Drive]=TRUE;
}

/****************************************************************************/
void BeebWin::ReadDisc(int Drive,HMENU dmenu)
{
	char StartPath[_MAX_PATH], DefaultPath[_MAX_PATH];
	char FileName[256];
	OPENFILENAME ofn;

	WCHAR w_StartPath[_MAX_PATH];
	WCHAR w_FileName[256];

	strcpy(DefaultPath, m_AppPath);
	strcat(DefaultPath, "discims");

	strcpy(StartPath, DefaultPath);
	ofn.nFilterIndex = 1;
  
	FileName[0] = '\0';
	wcscpy(w_FileName, _T(""));

	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, StartPath, -1, w_StartPath, 256);
//	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, FileName, -1, w_FileName, 256);

	/* Hmm, what do I put in all these fields! */
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = m_hWnd;
	ofn.hInstance = NULL;
	ofn.lpstrFilter = _T("Auto (*.ssd;*.dsd;*.ad*;*.img)\0*.ssd;*.dsd;*.adl;*.adf;*.img\0")
                    _T("ADFS Disc (*.adl *.adf)\0*.adl;*.adf\0")
                    _T("Single Sided Disc (*.ssd)\0*.ssd\0")
                    _T("Double Sided Disc (*.dsd)\0*.dsd\0")
                    _T("Single Sided Disc (*.*)\0*.*\0")
                    _T("Double Sided Disc (*.*)\0*.*\0");
	ofn.lpstrDefExt = NULL;
	ofn.lpstrFile = w_FileName;

	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nMaxFile = sizeof(w_FileName) / sizeof(TCHAR);
	ofn.Flags = OFN_PATHMUSTEXIST;

	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = w_StartPath;
	ofn.lpstrTitle = NULL;
//	ofn.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lCustData = 0;
	ofn.lpfnHook = NULL;
	ofn.lpTemplateName = NULL;

	if (GetOpenFileName(&ofn))
	{

		WideCharToMultiByte(CP_ACP, NULL, w_FileName, -1, FileName, 256, NULL, NULL);
		
		unsigned PathLength = strrchr(FileName, '\\') - FileName;
	    strncpy(DefaultPath, FileName, PathLength);
	    DefaultPath[PathLength] = 0;

	    bool dsd = false;
		bool adfs = false;
		switch (ofn.nFilterIndex) {
		    case 1:
			{
			char *ext = strrchr(FileName, '.');
			if (ext != NULL)
			if (strcmp(ext+1, "dsd") == 0)
				dsd = true;
			if (strcmp(ext+1, "adl") == 0)
				adfs = true;
			if (strcmp(ext+1, "adf") == 0)
				adfs = true;
			break;
			}
			case 2:
				adfs=true;
				break;
			case 4:
		    case 6:
				dsd = true;
		}
	
		if (dsd) {
			if (NativeFDC) LoadSimpleDSDiscImage(FileName, Drive, 80);
			else Load1770DiscImage(FileName,Drive,1,dmenu); } // 1 = dsd
		if ((!dsd) && (!adfs)) {
			if (NativeFDC) LoadSimpleDiscImage(FileName, Drive, 0, 80);
			else Load1770DiscImage(FileName,Drive,0,dmenu); } // 0 = ssd
		if (adfs) {
			if (NativeFDC) MessageBox(GETHWND,_T("The native 8271 FDC cannot read ADFS discs\n"),_T("BeebEm"),MB_OK|MB_ICONERROR); 
			else Load1770DiscImage(FileName,Drive,2,dmenu); } // 2 = adfs

		/* Write protect the disc */
		if (!m_WriteProtectDisc[Drive])
			ToggleWriteProtect(Drive);
	}
	strcpy(DefaultPath, m_AppPath);
}

void BeebWin::SelectFDC(void)
{
}

/****************************************************************************/
void BeebWin::NewDiscImage(int Drive)
{
	char StartPath[_MAX_PATH], DefaultPath[_MAX_PATH];
	char FileName[256];
	OPENFILENAME ofn;

	strcpy(DefaultPath, m_AppPath);
	strcat(DefaultPath, "discims");

	ofn.nFilterIndex = 1;
  
	FileName[0] = '\0';

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = m_hWnd;
	ofn.hInstance = NULL;
	ofn.lpstrFilter = _T("Single Sided Disc (*.ssd)\0*.ssd\0")
                    _T("Double Sided Disc (*.dsd)\0*.dsd\0")
                    _T("Single Sided Disc\0*.*\0")
                    _T("Double Sided Disc\0*.*\0")
					_T("ADFS M ( 80 Track) Disc\0*.adf\0")
					_T("ADFS L (160 Track) Disc\0*.adl\0");
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
//	ofn.lpstrFile = FileName;
	ofn.nMaxFile = sizeof(FileName);
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
//	ofn.lpstrInitialDir = StartPath;
	ofn.lpstrTitle = NULL;
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt = NULL;
	ofn.lCustData = 0;
	ofn.lpfnHook = NULL;
	ofn.lpTemplateName = NULL;

	if (GetSaveFileName(&ofn))
	{
    unsigned PathLength = strrchr(FileName, '\\') - FileName;
    strncpy(DefaultPath, FileName, PathLength);
    DefaultPath[PathLength] = 0;

		/* Add a file extension if the user did not specify one */
		if (strchr(FileName, '.') == NULL)
		{
			if (ofn.nFilterIndex == 1 ||
          ofn.nFilterIndex == 3)
				strcat(FileName, ".ssd");
			if (ofn.nFilterIndex == 2 ||
          ofn.nFilterIndex == 4)
				strcat(FileName, ".dsd");
			if (ofn.nFilterIndex==5)
				strcat(FileName, ".adf");
			if (ofn.nFilterIndex==6)
				strcat(FileName, ".adl");
		}

		if (ofn.nFilterIndex == 1 ||
        ofn.nFilterIndex == 3)
		{
			CreateDiscImage(FileName, Drive, 1, 80);
		}
		if (ofn.nFilterIndex == 2 ||
        ofn.nFilterIndex == 4)
		{
			CreateDiscImage(FileName, Drive, 2, 80);
		}
		if (ofn.nFilterIndex == 5) CreateADFSImage(FileName,Drive,80,m_hMenu);
		if (ofn.nFilterIndex == 6) CreateADFSImage(FileName,Drive,160,m_hMenu);

		/* Allow disc writes */
		if (m_WriteProtectDisc[Drive])
			ToggleWriteProtect(Drive);
		DWriteable[Drive]=1;
		DiscLoaded[Drive]=TRUE;
		strcpy(CDiscName[1],FileName);
	}
strcpy(DefaultPath, m_AppPath);
}

/****************************************************************************/
void BeebWin::ToggleWriteProtect(int Drive)
{
	HMENU hMenu = m_hMenu;
	if (m_WriteProtectDisc[Drive])
	{
		m_WriteProtectDisc[Drive] = 0;
		DiscWriteEnable(Drive, 1);
	}
	else
	{
		m_WriteProtectDisc[Drive] = 1;
		DiscWriteEnable(Drive, 0);
	}

	if (Drive == 0)
		CheckMenuItem(hMenu, IDM_WPDISC0, m_WriteProtectDisc[0] ? MF_CHECKED : MF_UNCHECKED);
	else
		CheckMenuItem(hMenu, IDM_WPDISC1, m_WriteProtectDisc[1] ? MF_CHECKED : MF_UNCHECKED);
}

/****************************************************************************/
void BeebWin::SavePreferences()
{
	char CfgValue[256];
	char CfgName[256];
	RECT wndrect;
	int LEDByte;

/*
  sprintf(CfgValue, "%d", m_MenuIdWinSize);
	WritePrivateProfileString(CFG_VIEW_SECTION, CFG_VIEW_WIN_SIZE,
			CfgValue, CFG_FILE_NAME);

	sprintf(CfgValue, "%d", m_ShowSpeedAndFPS);
	WritePrivateProfileString(CFG_VIEW_SECTION, CFG_VIEW_SHOW_FPS,
			CfgValue, CFG_FILE_NAME);

	sprintf(CfgValue, "%d", SoundEnabled);
	WritePrivateProfileString(CFG_SOUND_SECTION, CFG_SOUND_ENABLED,
			CfgValue, CFG_FILE_NAME);

	sprintf(CfgValue, "%d", m_MenuIdSampleRate);
	WritePrivateProfileString(CFG_SOUND_SECTION, CFG_SOUND_SAMPLE_RATE,
			CfgValue, CFG_FILE_NAME);

	sprintf(CfgValue, "%d", m_MenuIdVolume);
	WritePrivateProfileString(CFG_SOUND_SECTION, CFG_SOUND_VOLUME,
			CfgValue, CFG_FILE_NAME);

	sprintf(CfgValue, "%d", m_MenuIdTiming);
	WritePrivateProfileString(CFG_SPEED_SECTION, CFG_SPEED_TIMING,
			CfgValue, CFG_FILE_NAME);

	sprintf(CfgValue, "%d", m_MenuIdKeyMapping);
	WritePrivateProfileString(CFG_OPTIONS_SECTION, CFG_OPTIONS_KEY_MAPPING,
			CfgValue, CFG_FILE_NAME);

	sprintf(CfgValue, "%d", m_MenuIdSticks);
	WritePrivateProfileString(CFG_OPTIONS_SECTION, CFG_OPTIONS_STICKS,
			CfgValue, CFG_FILE_NAME);

	sprintf(CfgValue, "%d", m_FreezeWhenInactive);
	WritePrivateProfileString(CFG_OPTIONS_SECTION, CFG_OPTIONS_FREEZEINACTIVE,
			CfgValue, CFG_FILE_NAME);

	sprintf(CfgValue, "%d", m_HideCursor);
	WritePrivateProfileString(CFG_OPTIONS_SECTION, CFG_OPTIONS_HIDE_CURSOR,
			CfgValue, CFG_FILE_NAME);

	for (int key=0; key<256; ++key)
	{
		if (UserKeymap[key][0] != 0 || UserKeymap[key][1] != 0)
		{
			sprintf(CfgName, "%s%d", CFG_OPTIONS_USER_KEY_MAP, key);
			sprintf(CfgValue, "%d %d", UserKeymap[key][0], UserKeymap[key][1]);
			WritePrivateProfileString(CFG_OPTIONS_SECTION, CfgName,
				CfgValue, CFG_FILE_NAME);
		}
	}

	sprintf(CfgValue, "%d", palette_type);
	WritePrivateProfileString(CFG_VIEW_SECTION, CFG_VIEW_MONITOR,
			CfgValue, CFG_FILE_NAME);

*/
  
}

/****************************************************************************/
void BeebWin::SetWindowAttributes(bool wasFullScreen)
{
	HRESULT ddrval;
	RECT wndrect;
	RECT scrrect;
	long style;

	style = GetWindowLong(m_hWnd, GWL_STYLE);
	style &= ~WS_POPUP;
//	style |= WS_OVERLAPPED;
	SetWindowLong(m_hWnd, GWL_STYLE, style);

	SetWindowPos(m_hWnd, HWND_TOP, m_XWinPos, m_YWinPos,
		m_XWinSize + GetSystemMetrics(SM_CXFIXEDFRAME) * 2,
		m_YWinSize + GetSystemMetrics(SM_CYFIXEDFRAME) * 2
			+ 1,
		!wasFullScreen ? SWP_NOMOVE : 0);

}

void BeebWin::UpdateLEDMenu(HMENU hMenu) {
	// Update the LED Menu
	CheckMenuItem(hMenu,ID_RED_LEDS,(DiscLedColour>0)?MF_UNCHECKED:MF_CHECKED);
	CheckMenuItem(hMenu,ID_GREEN_LEDS,(DiscLedColour>0)?MF_CHECKED:MF_UNCHECKED);
	CheckMenuItem(hMenu,ID_SHOW_KBLEDS,(LEDs.ShowKB)?MF_CHECKED:MF_UNCHECKED);
	CheckMenuItem(hMenu,ID_SHOW_DISCLEDS,(LEDs.ShowDisc)?MF_CHECKED:MF_UNCHECKED);
}

void BeebWin::UpdateOptiMenu(void) {
	CheckMenuItem(m_hMenu,ID_DOCONLY,(OpCodes==1)?MF_CHECKED:MF_UNCHECKED);
	CheckMenuItem(m_hMenu,ID_EXTRAS ,(OpCodes==2)?MF_CHECKED:MF_UNCHECKED);
	CheckMenuItem(m_hMenu,ID_FULLSET,(OpCodes==3)?MF_CHECKED:MF_UNCHECKED);
	CheckMenuItem(m_hMenu,ID_BHARDWARE,(BHardware==1)?MF_CHECKED:MF_UNCHECKED);
	CheckMenuItem(m_hMenu,ID_TSTYLE,(THalfMode==1)?MF_CHECKED:MF_UNCHECKED);
	CheckMenuItem(m_hMenu,ID_1773,(SBSize==1)?MF_CHECKED:MF_UNCHECKED);
	CheckMenuItem(m_hMenu,ID_443,(SBSize==0)?MF_CHECKED:MF_UNCHECKED);
}
/***************************************************************************/
void BeebWin::HandleCommand(int MenuId)
{
    char TmpPath[256];
	BOOL b;
	HRESULT ddrval;
	HMENU hMenu = m_hMenu;
	int prev_palette_type = palette_type;
    SetSound(MUTED);
	switch (MenuId)
	{
	case IDM_LOADDISC0:
		ReadDisc(0,hMenu);
		MustEnableSound=TRUE;
		break;
	case IDM_LOADDISC1:
		ReadDisc(1,hMenu);
		MustEnableSound=TRUE;
		break;
		
	case IDM_NEWDISC0:
		NewDiscImage(0);
		MustEnableSound=TRUE;
		break;
	case IDM_NEWDISC1:
		NewDiscImage(1);
		MustEnableSound=TRUE;
		break;
		
	case IDM_WPDISC0:
		ToggleWriteProtect(0);
		break;
	case IDM_WPDISC1:
		ToggleWriteProtect(1);
		break;
		
	case IDM_160X128:
	case IDM_240X192:
	case IDM_640X256:
	case IDM_320X256:
	case IDM_640X512:
	case IDM_800X600:
	case IDM_1024X768:
	case IDM_1024X512:
		break;
			
	case IDM_SPEEDANDFPS:
		if (m_ShowSpeedAndFPS)
		{
			m_ShowSpeedAndFPS = FALSE;
			CheckMenuItem(hMenu, IDM_SPEEDANDFPS, MF_UNCHECKED);
			SetWindowText(m_hWnd, WindowTitle);
		}
		else
		{
			m_ShowSpeedAndFPS = TRUE;
			CheckMenuItem(hMenu, IDM_SPEEDANDFPS, MF_CHECKED);
		}
		break;
		
	case IDM_SOUNDONOFF:
		if (SoundDefault)
		{
			CheckMenuItem(hMenu, IDM_SOUNDONOFF, MF_UNCHECKED);
			SoundReset();
			SoundDefault=0;
		}
		else
		{
			SoundInit();
			if (SoundEnabled) {
				CheckMenuItem(hMenu, IDM_SOUNDONOFF, MF_CHECKED);
				SoundDefault=1;
			}
		}
		break;
		
	case IDM_44100KHZ:
	case IDM_22050KHZ:
	case IDM_11025KHZ:
		if (MenuId != m_MenuIdSampleRate)
		{
			CheckMenuItem(hMenu, m_MenuIdSampleRate, MF_UNCHECKED);
			m_MenuIdSampleRate = MenuId;
			CheckMenuItem(hMenu, m_MenuIdSampleRate, MF_CHECKED);
			TranslateSampleRate();
			
			if (SoundEnabled)
			{
				SoundReset();
				SoundInit();
			}
		}
		break;
		
	case IDM_FULLVOLUME:
	case IDM_HIGHVOLUME:
	case IDM_MEDIUMVOLUME:
	case IDM_LOWVOLUME:
		if (MenuId != m_MenuIdVolume)
		{
			CheckMenuItem(hMenu, m_MenuIdVolume, MF_UNCHECKED);
			m_MenuIdVolume = MenuId;
			CheckMenuItem(hMenu, m_MenuIdVolume, MF_CHECKED);
			TranslateVolume();
		}
		break;
		
	case IDM_ALLOWALLROMWRITES:	
		if (WritableRoms)
		{
			WritableRoms = FALSE;
			CheckMenuItem(hMenu, IDM_ALLOWALLROMWRITES, MF_UNCHECKED);
			GreyRomMenu( FALSE );	
		}
		else
		{
			WritableRoms = TRUE;
			CheckMenuItem(hMenu, IDM_ALLOWALLROMWRITES, MF_CHECKED);
			GreyRomMenu( TRUE );	
		}
		break;
		
		/* LRW Added switch individual ROMS Writable ON/OFF */
	case IDM_ALLOWWRITES_ROM0:
	case IDM_ALLOWWRITES_ROM1:
	case IDM_ALLOWWRITES_ROM2:
	case IDM_ALLOWWRITES_ROM3:
	case IDM_ALLOWWRITES_ROM4:
	case IDM_ALLOWWRITES_ROM5:
	case IDM_ALLOWWRITES_ROM6:
	case IDM_ALLOWWRITES_ROM7:
	case IDM_ALLOWWRITES_ROM8:
	case IDM_ALLOWWRITES_ROM9:
	case IDM_ALLOWWRITES_ROMA:
	case IDM_ALLOWWRITES_ROMB:
	case IDM_ALLOWWRITES_ROMC:
	case IDM_ALLOWWRITES_ROMD:
	case IDM_ALLOWWRITES_ROME:
	case IDM_ALLOWWRITES_ROMF:
		
		CheckMenuItem(hMenu,  MenuId, RomWritable[( MenuId-IDM_ALLOWWRITES_ROM0)] ? MF_UNCHECKED : MF_CHECKED );
		GetRomMenu();	// Update the Rom/Ram state for all the roms.
		break;				
		
	case IDM_REALTIME:
	case IDM_3QSPEED:
	case IDM_HALFSPEED:
	case IDM_50FPS:
	case IDM_25FPS:
	case IDM_10FPS:
	case IDM_5FPS:
	case IDM_1FPS:
		if (MenuId != m_MenuIdTiming)
		{
			CheckMenuItem(hMenu, m_MenuIdTiming, MF_UNCHECKED);
			m_MenuIdTiming = MenuId;
			CheckMenuItem(hMenu, m_MenuIdTiming, MF_CHECKED);
			TranslateTiming();
		}
		break;
		
	case IDM_JOYSTICK:
	case IDM_MOUSESTICK:
		/* Disable current selection */
		if (m_MenuIdSticks != 0)
		{
			CheckMenuItem(hMenu, m_MenuIdSticks, MF_UNCHECKED);
			if (m_MenuIdSticks == IDM_JOYSTICK)
			{
				ResetJoystick();
			}
			else /* mousestick */
			{
				AtoDReset();
			}
		}
		
		if (MenuId == m_MenuIdSticks)
		{
			/* Joysticks switched off completely */
			m_MenuIdSticks = 0;
		}
		else
		{
			/* Initialise new selection */
			m_MenuIdSticks = MenuId;
			if (m_MenuIdSticks == IDM_JOYSTICK)
			{
				InitJoystick();
			}
			else /* mousestick */
			{
				AtoDInit();
			}
			if (JoystickEnabled)
				CheckMenuItem(hMenu, m_MenuIdSticks, MF_CHECKED);
			else
				m_MenuIdSticks = 0;
		}
		break;
		
	case IDM_FREEZEINACTIVE:
		if (m_FreezeWhenInactive)
		{
			m_FreezeWhenInactive = FALSE;
			CheckMenuItem(hMenu, IDM_FREEZEINACTIVE, MF_UNCHECKED);
		}
		else
		{
			m_FreezeWhenInactive = TRUE;
			CheckMenuItem(hMenu, IDM_FREEZEINACTIVE, MF_CHECKED);
		}
		break;
		
	case IDM_HIDECURSOR:
		if (m_HideCursor)
		{
			m_HideCursor = FALSE;
			CheckMenuItem(hMenu, IDM_HIDECURSOR, MF_UNCHECKED);
		}
		else
		{
			m_HideCursor = TRUE;
			CheckMenuItem(hMenu, IDM_HIDECURSOR, MF_CHECKED);
		}
		break;
		
	case IDM_IGNOREILLEGALOPS:
		if (IgnoreIllegalInstructions)
		{
			IgnoreIllegalInstructions = FALSE;
			CheckMenuItem(hMenu, IDM_IGNOREILLEGALOPS, MF_UNCHECKED);
		}
		else
		{
			IgnoreIllegalInstructions = TRUE;
			CheckMenuItem(hMenu, IDM_IGNOREILLEGALOPS, MF_CHECKED);
		}
		break;
		
	case IDM_DEFINEKEYMAP:
		MustEnableSound=TRUE;
		break;
		
	case IDM_USERKYBDMAPPING:
	case IDM_KEYBOARDMAPPING1:
	case IDM_KEYBOARDMAPPING2:
		if (MenuId != m_MenuIdKeyMapping)
		{
			CheckMenuItem(hMenu, m_MenuIdKeyMapping, MF_UNCHECKED);
			m_MenuIdKeyMapping = MenuId;
			CheckMenuItem(hMenu, m_MenuIdKeyMapping, MF_CHECKED);
			TranslateKeyMapping();
		}
		break;
		
	case IDM_ABOUT:
		MessageBox(m_hWnd, AboutText, WindowTitle, MB_OK);
		break;
		
	case IDM_EXIT:
		// write out cmos ram first
		strcpy(TmpPath,RomPath); strcat(TmpPath,"/beebstate/cmos.ram");
		CMDF2=fopen(TmpPath,"wb");
		for(CMA2=0xe;CMA2<64;CMA2++) fputc(CMOSRAM[CMA2],CMDF2);
		fclose(CMDF2);
		SaveWindowPos(); // Save window co-ordinates
		PostMessage(m_hWnd, WM_CLOSE, 0, 0L);
		break;
		
	case IDM_SAVE_PREFS:
		SavePreferences();
		break;
		
	case ID_MONITOR_RGB:
		palette_type = RGB;
		CreateBitmap();
		break;
	case ID_MONITOR_BW:
		palette_type = BW;
		CreateBitmap();
		break;
	case ID_MONITOR_GREEN:
		palette_type = GREEN;
		CreateBitmap();
		break;
	case ID_MONITOR_AMBER:
		palette_type = AMBER;
		break;
		/*  case IDM_TUBE:
		TubeEnabled=1-TubeEnabled;
		CheckMenuItem(hMenu, IDM_TUBE, (TubeEnabled)?MF_CHECKED:MF_UNCHECKED); */
	case ID_FILE_RESET:
		ResetBeebSystem(0,0,0);
		break;
		/*  case IDM_TUBERESET:
		ResetBeebSystem(0,0,0);
		break; */
	case ID_HIDEMENU:
		HideMenuEnabled=1-HideMenuEnabled;
		CheckMenuItem(hMenu, ID_HIDEMENU, (HideMenuEnabled)?MF_CHECKED:MF_UNCHECKED);
		break;
	case ID_RED_LEDS:
		DiscLedColour=0;
		UpdateLEDMenu(hMenu);
		break;
	case ID_GREEN_LEDS:
		DiscLedColour=1;
		UpdateLEDMenu(hMenu);
		break;
	case ID_SHOW_KBLEDS:
		LEDs.ShowKB=!LEDs.ShowKB;
		UpdateLEDMenu(hMenu);
		break;
	case ID_SHOW_DISCLEDS:
		LEDs.ShowDisc=!LEDs.ShowDisc;
		UpdateLEDMenu(hMenu);
		break;
	case ID_FDC_DLL:
		SelectFDC();
		MustEnableSound=TRUE;
		break;
	case ID_8271:
		NativeFDC=TRUE;
		CheckMenuItem(m_hMenu,ID_8271,MF_CHECKED);
		CheckMenuItem(m_hMenu,ID_FDC_DLL,MF_UNCHECKED);
		break;
	case ID_TSTYLE:
		THalfMode=1-THalfMode;
		UpdateOptiMenu();
		break;
	case ID_DOCONLY:
		OpCodes=1;
		UpdateOptiMenu();
		break;
	case ID_EXTRAS:
		OpCodes=2;
		UpdateOptiMenu();
		break;
	case ID_FULLSET:
		OpCodes=3;
		UpdateOptiMenu();
		break;
	case ID_BHARDWARE:
		BHardware=1-BHardware;
		UpdateOptiMenu();
		break;
	case ID_PSAMPLES:
		PartSamples=1-PartSamples;
		UpdateOptiMenu();
		break;
	case ID_1773:
		SBSize=1;
		UpdateOptiMenu();
		break;
	case ID_443:
		SBSize=0;
		UpdateOptiMenu();
		break;
   }
   SetSound(UNMUTED);
   if (palette_type != prev_palette_type) {
	   CreateBitmap();
	   UpdateMonitorMenu();
   }
}

void BeebWin::SetPBuff(void) {
}

void BeebWin::SetSoundMenu(void) {
	CheckMenuItem(m_hMenu,IDM_SOUNDONOFF,(SoundEnabled)?MF_CHECKED:MF_UNCHECKED);
}

void BeebWin::Focus(BOOL gotit)
{
	if (gotit)
		m_frozen = FALSE;
	else
		if (m_FreezeWhenInactive)
			m_frozen = TRUE;
}

BOOL BeebWin::IsFrozen(void)
{
	return m_frozen;
}

void SaveEmuUEF(FILE *SUEF) {
}

void LoadEmuUEF(FILE *SUEF) {
}