// MainWindow.cpp : implementation file
//
#include "stdafx.h"
#include "resource.h"
#include "MainWindow.h"

#include "6502core.h"
#include "beebmem.h"
#include "beebsound.h"
#include "disc8271.h"
#include "sysvia.h"
#include "uservia.h"
#include "video.h"
#include "atodconv.h"
#include "main.h"
#include "disc1770.h"
#include "tube.h"
#include "uefstate.h"
#include "beebwin.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BeebWin *mainWin = NULL;
HINSTANCE hInst;

/////////////////////////////////////////////////////////////////////////////
// CMainWindow

CMainWindow::CMainWindow(HINSTANCE m_hInst)

{
CWinApp* pApp = AfxGetApp();

	// For MFCCE 2.0 and earlier, a command bar was created during
	// the CFrameWnd creation. For MFCCE 2.01 and later, a command bar 
	// is automatically created for you during the call to AddAdornments().

	LoadFrame(IDR_MAINFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL,
		NULL);
	
	m_wndCommandBar.m_bShowSharedNewButton = FALSE;

	if(!m_wndCommandBar.Create(this) ||
	   !m_wndCommandBar.InsertMenuBar(IDR_MAINFRAME) ||
	   !m_wndCommandBar.AddAdornments() )
	{
		TRACE0("Failed to create CommandBar\n");
		return;      // fail to create
	}

	m_hInstance = m_hInst;
	hInst = m_hInst;	

	mainWin=new BeebWin();

	mainWin->Initialise();
	SoundReset();
	if (SoundDefault) SoundInit();
	mainWin->ResetBeebSystem(0,0,1); 
	mainWin->SetRomMenu();
	mainWin->SetSoundMenu();
	mainWin->m_frozen=FALSE;

//		if (!mainWin->IsFrozen()) {
//			Exec6502Instruction();
//		}

}

CMainWindow::~CMainWindow()
{
}


BEGIN_MESSAGE_MAP(CMainWindow, CFrameWnd)
	//{{AFX_MSG_MAP(CMainWindow)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

