/****************************************************************************/
/*                               Beebem                                     */
/*                               ------                                     */
/* This program may be distributed freely within the following restrictions:*/
/*                                                                          */
/* 1) You may not charge for this program or for any part of it.            */
/* 2) This copyright message must be distributed with all copies.           */
/* 3) This program must be distributed complete with source code.  Binary   */
/*    only distribution is not permitted.                                   */
/* 4) The author offers no warrenties, or guarentees etc. - you use it at   */
/*    your own risk.  If it messes something up or destroys your computer   */
/*    thats YOUR problem.                                                   */
/* 5) You may use small sections of code from this program in your own      */
/*    applications - but you must acknowledge its use.  If you plan to use  */
/*    large sections then please ask the author.                            */
/*                                                                          */
/* If you do not agree with any of the above then please do not use this    */
/* program.                                                                 */
/****************************************************************************/
/* Mike Wyatt and NRM's port to win32 - 7/6/97 */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>


#include "6502core.h"
#include "beebmem.h"
#include "beebsound.h"
#include "sysvia.h"
#include "uservia.h"
#include "beebwin.h"
#include "disc8271.h"
#include "video.h"
#include "via.h"
#include "atodconv.h"
#include "disc1770.h"
#include "serial.h"

#ifdef MULTITHREAD
#undef MULTITHREAD
#endif

extern VIAState SysVIAState;
int DumpAfterEach=0;

BeebWin *mainWin = NULL;
HINSTANCE hInst;
DWORD iSerialThread,iStatThread; // Thread IDs

int CALLBACK WinMain(HINSTANCE hInstance, 
					HINSTANCE hPrevInstance,
					LPWSTR lpszCmdLine,
					int nCmdShow)
{
	MSG msg;
	int i;

	hInst = hInstance;

	mainWin=new BeebWin();

	mainWin->Initialise();
	SoundReset();
	if (SoundDefault) SoundInit();
	mainWin->ResetBeebSystem(0,0,1); 
	mainWin->SetRomMenu();
	mainWin->SetSoundMenu();
	mainWin->m_frozen=FALSE;

	do
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg,    // message structure
							NULL,   // handle of window receiving the message
							0,      // lowest message to examine
							0))
				break;              // Quit the app on WM_QUIT
  
			TranslateMessage(&msg);// Translates virtual key codes
			DispatchMessage(&msg); // Dispatches message to window
		}

		for (i = 0; i < 20; ++i)
			Exec6502Instruction();

	} while(1);
	
	delete mainWin;
	return(0);  
} /* main */
